//this file is part of eMule
//Copyright (C)2006 David Xanatos ( Xanatos@Lycos.at / http://neomule.sourceforge.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "OtherFunctions.h"
#include "EMF/TreeControl/TreeOptionsCtrl.h" //==> dlarge TreeControl
#include "TreeFunctions.h"
#include "preferences.h"


void SetTreeGroup(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, int Icon, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertGroup(Label,Icon, Parent); 
	hCtrl.SetItemInfo(hItem, Info ? Info : BLANK_INFO);
}

void SetTreeEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info){
	hItem = hCtrl.InsertItem(Label, TREEOPTSCTRLIMG_EDIT, TREEOPTSCTRLIMG_EDIT, Parent);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void DDX_TreeEditE0(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, int& nValue)
{
	if (!pDX->m_bSaveAndValidate)
		if(nValue == 0){
			hCtrl->SetEditText(hItem, _T(""));
			return;
		}

	DDX_TreeEdit(pDX, nIDC, hItem, nValue);
}

void DDX_TreeEditE0f(CTreeOptionsCtrl* hCtrl, CDataExchange* pDX, int nIDC, HTREEITEM hItem, float& nValue)
{
	if (!pDX->m_bSaveAndValidate)
		if(nValue == 0){
			hCtrl->SetEditText(hItem, _T(""));
			return;
		}

	DDX_TreeEdit(pDX, nIDC, hItem, nValue);
}

BOOL CheckTreeEditLimit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, int Min, int Def, int Max){
	CString strBuffer = hCtrl.GetEditText(hItem);
	if(!strBuffer.IsEmpty()){
		int iOldBuffer = _tstol(strBuffer);
		int iBuffer = Str2Int(strBuffer,Min,Def,Max);
		if(iBuffer != iOldBuffer){
			hCtrl.SetEditText(hItem,Int2Str(iBuffer));
			return TRUE;
		}
	}
	return FALSE;
}

void SetTreeCheckEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeCheckNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeRadioNumEdit(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL UnSetable, BOOL Value){
	hItem = hCtrl.InsertRadioButton(Label, Parent, Value, TVI_LAST, NULL, NULL, UnSetable);
	hCtrl.AddEditBox(hItem,RUNTIME_CLASS(CNumTreeOptionsEdit));
	hCtrl.SetItemInfo(hItem,Info);
}


void SetTreeCheck(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent, LPCTSTR Info, BOOL TreeState, BOOL Value){
	hItem = hCtrl.InsertCheckBox(Label,Parent,Value,TreeState?1:0);
	hCtrl.SetItemInfo(hItem,Info);
}

void SetTreeRadio(CTreeOptionsCtrl &hCtrl, HTREEITEM &hItem, LPCTSTR Label, HTREEITEM Parent,  LPCTSTR Info, BOOL UnSetable, BOOL Value){
	hItem = hCtrl.InsertRadioButton(Label, Parent, Value, TVI_LAST, NULL, NULL, UnSetable);
	hCtrl.SetItemInfo(hItem,Info);
}

CString Int2Str(int Nummer) { 
	CString buffer=_T("0"); 
	buffer.Format(_T("%d"), Nummer); 
	return buffer; 
}

int Str2Int(CString Buffer, int Min, int Def, int Max){
	int itemp = _tstol(Buffer);
	if (!itemp)
		itemp = Def;
	else
		if(Min && Max)
			MinMax(&itemp,Min,Max);
		else if(Min)
			Minimal(&itemp,Min);
	return itemp;
}